package Daje::Workflow::Database::Model::History;
use Mojo::Base -base, -signatures;


# NAME
# ====
#
# Daje::Workflow::Database::Model::History
#
#
# REQUIRES
# ========
#
# Mojo::Base>
#
# METHODS
# =======
#
#  insert($self, $data);
#
#  load_list($self, $workflow_pkey);
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#


has 'db';

sub load_list($self, $workflow_fkey) {
    my $data = $self->db->select(
        'workflow',  ['*'],
        {
            workflow_fkey => $workflow_fkey
        }
    );
    my $hashes;

    $hashes = $data->hashes if $data->rows > 0;

    return $hashes;
}

sub insert($self, $data) {
    $self->db->insert(
        'history',
        {
            %$data
        }
    );
}

1;












#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Database::Model::History




=head1 REQUIRES


Mojo::Base>



=head1 METHODS


 insert($self, $data);

 load_list($self, $workflow_pkey);




=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

