# ssh-proxy-ice-gsocket

This project aims to develop an SSH proxy that leverages the ICE protocol
(RFC 8445) for data transmission. By employing Ice's communication
capabilities, this proxy facilitates the establishment of secure SSH
connections, enabling clients to access SSH servers effectively even
when traversing Network Address Translation (NAT) boundaries. This
approach offers a robust solution for scenarios where direct SSH access
is hindered by NAT restrictions.

## Build

This project utilizes CMake as its build system.
For instance, to build the project with debug information enabled,
the following command sequence can be employed:

 * cmake -DCMAKE_BUILD_TYPE=Debug .
 * make

## Dependencies

This program requires the gs-netcat utility, which is part of the gsocket
project. To ensure proper program functionality, it is necessary to install
the gsocket package. On Debian-based systems, this can typically be achieved
by executing the following command in the terminal:

 * sudo apt install gsocket

## Usage

Please use "-s" option to set gsocket_secret in ssh-proxy-ice-cli.c and
ssh-proxy-ice-srv.c.
It is crucial to ensure that the gsocket_secret values are identical
in both commands to guarantee successful communication
To enhance security and prevent unauthorized usage by others, it is strongly
recommended to utilize a unique and personally chosen secret.

To initiate the server, execute the following command in the terminal:

 * ssh-proxy-ice-srv -s MySecret

This command will commence the forwarding of local connections on port 22
by the ICE protocol.

Subsequently, on the client machine, establish an SSH connection using the
following command:

 * ssh -C -o ProxyCommand='ssh-proxy-ice-cli -s MySecret' server.hostname

This command instructs the SSH client to utilize the ssh-ice-cli program
as a proxy, passing the specified gsocket_secret for authentication.
If the ICE connection can be successfully established, the SSH client will
then proceed to connect to the remote server.
