/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

public final class ZipLong
implements Cloneable {
    private long value;

    public ZipLong(long value) {
        this.value = value;
    }

    public ZipLong(byte[] bytes) {
        this(bytes, 0);
    }

    public ZipLong(byte[] bytes, int offset) {
        this.value = ZipLong.convert(bytes, offset);
    }

    public byte[] getBytes() {
        return ZipLong.bytes(this.value);
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ZipLong)) {
            return false;
        }
        return this.value == ((ZipLong)o).getValue();
    }

    public int hashCode() {
        return (int)this.value;
    }

    static long convert(byte[] bytes) {
        return ZipLong.convert(bytes, 0);
    }

    static long convert(byte[] bytes, int offset) {
        long value = (long)(bytes[offset + 3] << 24) & 0xFF000000L;
        value += (long)(bytes[offset + 2] << 16 & 0xFF0000);
        value += (long)(bytes[offset + 1] << 8 & 0xFF00);
        return value += (long)(bytes[offset] & 0xFF);
    }

    static byte[] bytes(long value) {
        return ZipLong.bytes(value, new byte[4]);
    }

    static byte[] bytes(long value, byte[] result) {
        result[0] = (byte)(value & 0xFFL);
        result[1] = (byte)((value & 0xFF00L) >> 8);
        result[2] = (byte)((value & 0xFF0000L) >> 16);
        result[3] = (byte)((value & 0xFF000000L) >> 24);
        return result;
    }
}

