# Generated by default/object.tt
package Paws::CodeGuruReviewer::Metrics;
  use Moose;
  has FindingsCount => (is => 'ro', isa => 'Int');
  has MeteredLinesOfCodeCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::Metrics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::Metrics object:

  $service_obj->Method(Att1 => { FindingsCount => $value, ..., MeteredLinesOfCodeCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::Metrics object:

  $result = $service_obj->Method(...);
  $result->Att1->FindingsCount

=head1 DESCRIPTION

Information about the statistics from the code review.

=head1 ATTRIBUTES


=head2 FindingsCount => Int

Total number of recommendations found in the code review.


=head2 MeteredLinesOfCodeCount => Int

Lines of code metered in the code review. For the initial code review
pull request and all subsequent revisions, this includes all lines of
code in the files added to the pull request. In subsequent revisions,
for files that already existed in the pull request, this includes only
the changed lines of code. In both cases, this does not include
non-code lines such as comments and import statements. For example, if
you submit a pull request containing 5 files, each with 500 lines of
code, and in a subsequent revision you added a new file with 200 lines
of code, and also modified a total of 25 lines across the initial 5
files, C<MeteredLinesOfCodeCount> includes the first 5 files (5 * 500 =
2,500 lines), the new file (200 lines) and the 25 changed lines of code
for a total of 2,725 lines of code.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

