# Generated by default/object.tt
package Paws::CloudFront::OriginShield;
  use Moose;
  has Enabled => (is => 'ro', isa => 'Bool', required => 1);
  has OriginShieldRegion => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::OriginShield

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::OriginShield object:

  $service_obj->Method(Att1 => { Enabled => $value, ..., OriginShieldRegion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::OriginShield object:

  $result = $service_obj->Method(...);
  $result->Att1->Enabled

=head1 DESCRIPTION

CloudFront Origin Shield.

Using Origin Shield can help reduce the load on your origin. For more
information, see Using Origin Shield
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html)
in the I<Amazon CloudFront Developer Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Enabled => Bool

A flag that specifies whether Origin Shield is enabled.

When itE<rsquo>s enabled, CloudFront routes all requests through Origin
Shield, which can help protect your origin. When itE<rsquo>s disabled,
CloudFront might send requests directly to your origin from multiple
edge locations or regional edge caches.


=head2 OriginShieldRegion => Str

The AWS Region for Origin Shield.

Specify the AWS Region that has the lowest latency to your origin. To
specify a region, use the region code, not the region name. For
example, specify the US East (Ohio) region as C<us-east-2>.

When you enable CloudFront Origin Shield, you must specify the AWS
Region for Origin Shield. For the list of AWS Regions that you can
specify, and for help choosing the best Region for your origin, see
Choosing the AWS Region for Origin Shield
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region)
in the I<Amazon CloudFront Developer Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

