#!perl -w

use strict;
use warnings;
use FindBin qw($Bin);
use File::Spec;
use Test::Most tests => 3;
use Test::Needs 'Test::Carp';
use Carp;
use lib 't/lib';

ERROR: {
	Test::Carp->import();

	use_ok('Database::test1');
	my $directory = File::Spec->catfile($Bin, File::Spec->updir(), 't', 'data');

	my $test1 = new_ok('Database::test1' => [$directory]);

	does_croak_that_matches(sub {
		my $non_existant = Database::test1->new({directory => $directory, dbname => 'nan', max_slurp_size => 0});
		cmp_ok($non_existant->number('three'), '==', 3, "Database doesn't exist");
	}, qr/Can't find/);
}
